<?php defined('_JEXEC') or die;
/*
 * @package     mod_uk_slider
 * @copyright   Copyright (C) Joomlaplates. All rights reserved.
 * @license     GNU General Public License version 3 or later; see http://www.gnu.org/licenses/gpl-3.0.txt
 */

?>
<style type="text/css">

.uk-card-media-top img { transform: scale(1); transform-origin: 50% 50% 0px; transition: all 0.3s ease 0s; }
.uk-card-media-top a:hover img { transform: scale(1.0); }
.uk-card-media-top .item-image-backdrop { position: absolute; top: 0px; left: 0px; z-index: 10; width: 100%; height: 100%; background-color: rgb(0, 0, 0); visibility: hidden; opacity: 0; transition: all 0.3s ease 0s; }
.uk-card-media-top a:hover .item-image-backdrop { visibility: visible; opacity: 0.7; }
.uk-card-media-top .item-image-backdrop::before { content: ""; z-index: 11; display: block; width: 25px; height: 1px; background-color: rgb(255, 255, 255); position: absolute; top: 50%; left: 50%; margin-left: -12px; transition: all 0.3s ease 0s; transform: translateX(-150px); }
.uk-card-media-top .item-image-backdrop::after { content: ""; z-index: 12; display: block; width: 1px; height: 25px; background-color: rgb(255, 255, 255); position: absolute; top: 50%; left: 50%; margin-top: -12px; transition: all 0.3s ease 0s; transform: translateY(-150px); }
.uk-card-media-top a:hover .item-image-backdrop::before { transform: translateX(0px); }
.uk-card-media-top a:hover .item-image-backdrop::after { transform: translateY(0px); }

</style>

<div uk-slider >
    <div class=""  >
        <ul class="uk-slider-items uk-child-width-1-2@m uk-grid-match" uk-grid >
            <?php
            foreach ($items as $item)
            {
                $item_slide_class = trim($item->class) ? ' ' . trim($item->class) : '';
                $item_class = $item_class || $item_slide_class ? ' class="' . $item_class . $item_slide_class . '"' : '';
            ?>
            <li>
				<div class="uk-card uk-card-default uk-grid-collapse uk-child-width-1-2@s" uk-grid >
					<div class="uk-card-media-left uk-cover-container">
						<img src="<?php echo $item->img; ?>" alt="" uk-cover >
						<canvas width="300" height="300"></canvas>
					</div>
					<div>
						<div class="uk-card-body">
							<h3 class="uk-card-title"><?php echo $item->title; ?></h3>
							<p><?php echo $item->content; ?></p>
						</div>
					</div>
				</div>
			
            </li>
            <?php } ?>
        </ul>
    </div>
    
    <?php if ($slidenav) { ?>
    <a class="uk-position-center-left uk-position-small uk-hidden-hover" href="#" data-uk-slidenav-previous data-uk-slider-item="previous"></a>
    <a class="uk-position-center-right uk-position-small uk-hidden-hover" href="#" data-uk-slidenav-next data-uk-slider-item="next"></a>
    <?php } ?>
    
    <?php if ($dotnav) { ?>
    <div class="uk-flex uk-flex-center uk-margin-small-top mt-3">
        <ul class="uk-slider-nav uk-dotnav"></ul>
    </div>
    <?php } ?>
    
</div>
